/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.FontMetrics;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlWriter;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.ExpressionString;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.TextEditDialog;
import rene.zirkel.objects.TextObjectDialog;

public class TextObject
extends ConstructionObject
implements MoveableObject {
    protected double X;
    protected double Y;
    Vector T;
    static Count N = new Count();
    double C;
    double R;
    double W;
    double H;
    protected Expression EX;
    protected Expression EY;
    protected boolean Fixed;
    protected boolean DoShow;
    double oldx;
    double oldy;
    double startx;
    double starty;

    public TextObject(Construction construction, double d2, double d3) {
        super(construction);
        this.X = d2;
        this.Y = d3;
        this.T = new Vector();
        this.setColor(this.ColorIndex);
        this.Valid = true;
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        return this.C <= (double)n && this.R <= (double)n2 && (double)n <= this.C + this.W && (double)n2 <= this.R + this.H;
    }

    public String getTag() {
        return "Text";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        this.setText(this.getLines(), true);
    }

    public void move(double d2, double d3) {
        this.X = d2;
        this.Y = d3;
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        String string;
        this.C = zirkelCanvas.col(this.X);
        this.R = zirkelCanvas.row(this.Y);
        if (this.mustHide(zirkelCanvas)) {
            return;
        }
        boolean bl = this.Hidden;
        if (this.DoShow) {
            this.Hidden = false;
        }
        myGraphics.setColor(this);
        this.setFont(myGraphics);
        if (this.DoShow) {
            this.Hidden = bl;
        }
        FontMetrics fontMetrics = myGraphics.getFontMetrics();
        this.W = this.H = (double)fontMetrics.getHeight();
        Enumeration enumeration = this.T.elements();
        double d2 = this.R;
        if (!enumeration.hasMoreElements()) {
            string = "-";
            myGraphics.drawString(string, this.C, d2);
            d2 += this.H;
        }
        while (enumeration.hasMoreElements()) {
            string = ((ExpressionString)enumeration.nextElement()).evaluate();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (string.startsWith("***")) {
                string = string.substring(3);
                bl4 = true;
                bl3 = true;
            } else if (string.startsWith("**")) {
                string = string.substring(2);
                bl4 = true;
            } else if (string.startsWith("*")) {
                string = string.substring(1);
                bl3 = true;
            }
            if (myGraphics instanceof MyGraphics13) {
                if (this.isStrongSelected()) {
                    ((MyGraphics13)myGraphics).drawMarkerRect(this.C, d2, 10.0, 10.0);
                    myGraphics.setColor(this);
                }
                myGraphics.setFont(bl4, bl3);
                d2 += (double)((MyGraphics13)myGraphics).drawStringExtended(string, this.C, d2);
                continue;
            }
            myGraphics.setFont(bl4, bl3);
            fontMetrics = myGraphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            myGraphics.drawString(AngleObject.translateToUnicode(string), this.C, d2);
            d2 += this.H;
        }
        this.H = d2 - this.R;
    }

    public boolean mustHide(ZirkelCanvas zirkelCanvas) {
        return super.mustHide(zirkelCanvas) && (!this.Valid || !this.DoShow);
    }

    public void validate() {
        this.Valid = true;
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            try {
                this.X = this.EX.getValue();
            }
            catch (Exception exception) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            try {
                this.Y = this.EY.getValue();
            }
            catch (Exception exception) {
                this.Valid = false;
                return;
            }
        }
    }

    public String getLines() {
        String string = "";
        Enumeration enumeration = this.T.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = ((ExpressionString)enumeration.nextElement()).toString();
            string = string + string2;
            if (!enumeration.hasMoreElements()) continue;
            string = string + "\n";
        }
        return string;
    }

    public void setLines(String string) {
        Vector<ExpressionString> vector = new Vector<ExpressionString>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.addElement(new ExpressionString(string2, this));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.T = vector;
        this.updateText();
    }

    public String getDisplayValue() {
        return "(" + this.roundDisplay(this.X) + "," + this.roundDisplay(this.Y) + ")";
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        TextObjectDialog textObjectDialog = new TextObjectDialog(zirkelCanvas.getFrame(), this);
        textObjectDialog.setVisible(true);
        zirkelCanvas.repaint();
        if (textObjectDialog.wantSettings()) {
            new TextEditDialog(zirkelCanvas.getFrame(), this).setVisible(true);
            zirkelCanvas.validate();
            zirkelCanvas.repaint();
        }
        if (textObjectDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            xmlWriter.printArg("x", this.EX.toString());
        } else {
            xmlWriter.printArg("x", "" + this.X);
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            xmlWriter.printArg("y", this.EY.toString());
        } else {
            xmlWriter.printArg("y", "" + this.Y);
        }
        if (this.Fixed) {
            xmlWriter.printArg("fixed", "true");
        }
    }

    public boolean moveable() {
        return !this.Fixed;
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean bl) {
        this.Fixed = bl;
        if (!this.Fixed) {
            this.EY = null;
            this.EX = null;
        }
        this.updateText();
    }

    public void setFixed(String string, String string2) {
        this.Fixed = true;
        this.EX = new Expression(string, this.getConstruction(), this);
        this.EY = new Expression(string2, this.getConstruction(), this);
        this.updateText();
    }

    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return "" + this.round(this.X);
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "" + this.round(this.Y);
    }

    public void setDoShow(boolean bl) {
        this.DoShow = bl;
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.getGridSize() / 2.0;
        this.X = (double)Math.round(this.X / d2) * d2;
        this.Y = (double)Math.round(this.Y / d2) * d2;
    }

    public void translate() {
        if (this.Fixed) {
            try {
                this.setFixed(this.EX.toString(), this.EY.toString());
                this.EX.translate();
                this.EY.translate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setLines(this.getLines());
        Enumeration enumeration = this.T.elements();
        while (enumeration.hasMoreElements()) {
            ((ExpressionString)enumeration.nextElement()).translate();
        }
    }

    public Enumeration depending() {
        super.depending();
        Enumeration enumeration = this.T.elements();
        while (enumeration.hasMoreElements()) {
            ((ExpressionString)enumeration.nextElement()).addDep(this);
        }
        if (this.Fixed) {
            if (this.EX != null) {
                this.EX.addDep(this);
            }
            if (this.EY != null) {
                this.EY.addDep(this);
            }
        }
        return DL.elements();
    }

    public boolean canDisplayName() {
        return false;
    }

    public void startDrag(double d2, double d3) {
        this.oldx = this.X;
        this.oldy = this.Y;
        this.startx = d2;
        this.starty = d3;
    }

    public void dragTo(double d2, double d3) {
        this.move(this.oldx + (d2 - this.startx), this.oldy + (d3 - this.starty));
    }
}

