/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "popmenu.h"
#include <QString>
#include <QDebug>
#include <QFont>
#include <QApplication>
#include <QKeyEvent>

PopMenu::PopMenu()
{
    QFont font;
    font.setPixelSize(12);
    this->setFont(font);
}

void PopMenu::setStringList(QStringList strings)
{
    this->clear();
    int i = -1;
    for (QString str : strings) {
        QAction* act = new QAction(str,this);
        this->addAction(act);
        i++;
        connect(act, &QAction::triggered, this, [=](){
            emit listAactive(i);
        });
    }
}

void PopMenu::showPopLists(QPoint pos)
{
    this->adjustSize();
    QSize size = this->size();
    //弹出列表移动到鼠标上方
    this->move(pos.x() - size.width() / 2 - 5, pos.y() - size.height() - 4);
    this->show();
}

void PopMenu::keyPressEvent(QKeyEvent *event)
{
    if(event->key() == Qt::Key_Escape) {
        this->hide();
    }
    QMenu::keyPressEvent(event);
}

void PopMenu::hideEvent(QHideEvent *event)
{
    qApp->removeEventFilter(this);

    this->releaseKeyboard();
    QMenu::hideEvent(event);
    emit this->listHide();
}
