use csscolorparser::parse;

#[test]
fn hex() {
    let test_data = [
        "#71fe15",
        "#d6e3c9",
        "#2a7719",
        "#b53717",
        "#5b0b8d",
        "#aff632",
        "#65ec8d",
        "#d35493",
        "#289e5f",
        "#b46152",
        "#e0afee",
        "#ac2be4",
        "#233490",
        "#1afbc5",
        "#e41755",
        "#e052ee",
        "#4d1b5e",
        "#230cde",
        "#f8a243",
        "#a130d1",
        "#b38373",
        "#6b9fa203",
        "#0e5e0be6",
        "#84f9a716",
        "#48651550",
        "#1adc2cf4",
        "#c191a31c",
        "#a25518c5",
        "#cb33f2c9",
        "#89b21d36",
        "#cbb97f3e",
    ];
    for s in test_data {
        let c = parse(s).unwrap();
        assert_eq!(s, c.to_css_hex());
    }
}

#[test]
fn rgb() {
    let test_data = [
        "rgb(71 175 99)",
        "rgb(170 203 72)",
        "rgb(45 232 237)",
        "rgb(119 1 124)",
        "rgb(243 93 86)",
        "rgb(223 25 119)",
        "rgb(6 44 133)",
        "rgb(167 240 237)",
        "rgb(97 71 129)",
        "rgb(125 68 93)",
        "rgb(139 187 62)",
        "rgb(100 51 80)",
        "rgb(27 249 123)",
        "rgb(230 63 99)",
        "rgb(241 34 4)",
        "rgb(149 222 185)",
        "rgb(3 129 213)",
        "rgb(88 220 108)",
        "rgb(199 169 6)",
        "rgb(54 70 163)",
        "rgb(90 42 106)",
    ];
    for s in test_data {
        let c = parse(s).unwrap();
        assert_eq!(s, c.to_css_rgb());
    }
}

#[test]
fn hsl() {
    let test_data = [
        "hsl(0 48% 83%)",
        "hsl(17 73% 13%)",
        "hsl(35 40% 84%)",
        "hsl(53 88% 21%)",
        "hsl(71 11% 45%)",
        "hsl(89 12% 89%)",
        "hsl(107 49% 68%)",
        "hsl(125 96% 72%)",
        "hsl(143 15% 92%)",
        "hsl(161 80% 93%)",
        "hsl(179 45% 76%)",
        "hsl(197 99% 84%)",
        "hsl(215 33% 15%)",
        "hsl(233 69% 59%)",
        "hsl(251 34% 46%)",
        "hsl(269 43% 18%)",
        "hsl(287 89% 69%)",
        "hsl(305 87% 36%)",
        "hsl(323 97% 26%)",
        "hsl(341 61% 66%)",
        "hsl(359 15% 74%)",
    ];
    for s in test_data {
        let c = parse(s).unwrap();
        assert_eq!(s, c.to_css_hsl());
    }
}

#[test]
fn hwb() {
    let test_data = [
        "hwb(0 87% 0%)",
        "hwb(17 0% 23%)",
        "hwb(35 0% 7%)",
        "hwb(53 66% 0%)",
        "hwb(71 0% 66%)",
        "hwb(89 22% 0%)",
        "hwb(107 0% 2%)",
        "hwb(125 51% 0%)",
        "hwb(143 10% 0%)",
        "hwb(161 0% 76%)",
        "hwb(179 72% 0%)",
        "hwb(197 0% 60%)",
        "hwb(215 0% 39%)",
        "hwb(233 0% 18%)",
        "hwb(251 0% 3%)",
        "hwb(269 57% 0%)",
        "hwb(287 21% 0%)",
        "hwb(305 15% 0%)",
        "hwb(323 55% 0%)",
        "hwb(341 0% 72%)",
        "hwb(359 0% 2%)",
    ];
    for s in test_data {
        let c = parse(s).unwrap();
        assert_eq!(s, c.to_css_hwb());
    }
}

#[test]
fn oklab() {
    let test_data = [
        "oklab(0.623 0.019 -0.359)",
        "oklab(0.362 -0.314 -0.035)",
        "oklab(0.804 0.166 -0.072)",
        "oklab(0.832 0.089 0.265)",
        "oklab(0.681 0.038 -0.3)",
        "oklab(0.117 -0.192 0.24)",
        "oklab(0.651 -0.241 -0.158)",
        "oklab(0.421 -0.248 0.053)",
        "oklab(0.923 -0.119 -0.288)",
        "oklab(0.811 -0.295 0.347)",
        "oklab(0.485 -0.368 0.066)",
        "oklab(0.905 0.13 -0.163)",
        "oklab(0.778 -0.001 0.4)",
        "oklab(0.672 0.136 -0.03)",
        "oklab(0.926 0.281 0.279)",
        "oklab(0.247 0.155 0.379)",
        "oklab(0.503 0.042 0.202)",
        "oklab(0.792 -0.34 -0.372)",
        "oklab(0.877 -0.13 0.222)",
        "oklab(0.898 -0.068 -0.239)",
        "oklab(0.725 -0.343 -0.352)",
    ];
    for s in test_data {
        let c = parse(s).unwrap();
        assert_eq!(s, c.to_css_oklab());
    }
}

#[test]
fn oklch() {
    let test_data = [
        "oklch(0.284 0.132 0)",
        "oklch(0.314 0.136 17)",
        "oklch(0.935 0.398 35)",
        "oklch(0.729 0.175 53)",
        "oklch(0.157 0.29 71)",
        "oklch(0.266 0.365 89)",
        "oklch(0.12 0.225 107)",
        "oklch(0.532 0.274 125)",
        "oklch(0.571 0.201 143)",
        "oklch(0.948 0.217 161)",
        "oklch(0.501 0.2 179)",
        "oklch(0.184 0.308 197)",
        "oklch(0.308 0.273 215)",
        "oklch(0.874 0.143 233)",
        "oklch(0.544 0.186 251)",
        "oklch(0.144 0.255 269)",
        "oklch(0.997 0.327 287)",
        "oklch(0.544 0.22 305)",
        "oklch(0.578 0.203 323)",
        "oklch(0.819 0.343 341)",
        "oklch(0.497 0.188 359)",
    ];
    for s in test_data {
        let c = parse(s).unwrap();
        assert_eq!(s, c.to_css_oklch());
    }
}

#[cfg(feature = "lab")]
#[test]
fn lab() {
    let test_data = [
        "lab(57.32 70.93 101.73)",
        "lab(19.94 -109.64 -111.1)",
        "lab(54.5 -21.31 -64.68)",
        "lab(10.25 27.72 90.4)",
        "lab(33.83 105.64 37.89)",
        "lab(83.56 108.72 89.22)",
        "lab(40.01 105.35 -85.3)",
        "lab(30.1 21.78 -92.17)",
        "lab(99.19 0.44 93.11)",
        "lab(93.32 55.85 -9.14)",
        "lab(78.31 -23.69 -27.56)",
        "lab(42.64 -22.56 -45.68)",
        "lab(69.27 113.33 37.39)",
        "lab(24.6 -37.2 88.99)",
        "lab(72.6 -41.31 11.88)",
        "lab(12.44 -6.94 69.89)",
        "lab(71.23 -91.08 31.29)",
        "lab(5.18 65.67 63.53)",
        "lab(18.7 19.92 67.2)",
        "lab(14.62 71.89 57.13)",
        "lab(76.47 77.56 -107.61)",
    ];
    for s in test_data {
        let c = parse(s).unwrap();
        assert_eq!(s, c.to_css_lab());
    }
}

#[cfg(feature = "lab")]
#[test]
fn lch() {
    let test_data = [
        "lch(16.4 138.03 0)",
        "lch(7.88 52.89 17.95)",
        "lch(19.43 25.84 35.9)",
        "lch(73.85 45.9 53.85)",
        "lch(72.85 126.69 71.8)",
        "lch(42.26 71.09 89.75)",
        "lch(99.21 108.15 107.7)",
        "lch(13.05 38.12 125.65)",
        "lch(46.73 30.27 143.6)",
        "lch(33.88 90.43 161.55)",
        "lch(89.29 23.68 179.5)",
        "lch(20.69 14.49 197.45)",
        "lch(64.73 27.25 215.4)",
        "lch(61.08 70.57 233.35)",
        "lch(40.84 141.03 251.3)",
        "lch(7.45 91.95 269.25)",
        "lch(53.33 83.53 287.2)",
        "lch(26.3 52.41 305.15)",
        "lch(33.6 42.99 323.1)",
        "lch(90.17 91 341.05)",
        "lch(33.83 10.5 359)",
    ];
    for s in test_data {
        let c = parse(s).unwrap();
        assert_eq!(s, c.to_css_lch());
    }
}
