/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.template;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.turbine.modules.LayoutLoader;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.template.TemplateEngineService;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.RunData;
import org.apache.velocity.runtime.configuration.Configuration;

public class TurbineTemplateService
extends TurbineBaseService
implements TemplateService {
    protected static final String NO_FILE_EXT = "";
    protected static final int PAGE_KEY = 0;
    protected static final int SCREEN_KEY = 1;
    protected static final int LAYOUT_KEY = 2;
    protected static final int NAVIGATION_KEY = 3;
    protected static final int LAYOUT_TEMPLATE_KEY = 4;
    protected static final int SCREEN_TEMPLATE_KEY = 5;
    private String[] defaultNameProperties = new String[]{"default.page", "default.screen", "default.layout", "default.navigation", "default.layout.template"};
    private Hashtable[] templateNameCache = new Hashtable[6];
    private boolean useCache = false;
    private String defaultExtension;
    private String defaultTemplate;
    private HashMap templateEngineRegistry;

    public void init() throws InitializationException {
        this.initTemplate();
        this.setInit(true);
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public String getDefaultPage() {
        return this.getDefaultPageName(this.defaultTemplate);
    }

    public String getDefaultScreen() {
        return this.getDefaultScreenName(this.defaultTemplate);
    }

    public String getDefaultLayout() {
        return this.getDefaultLayoutName(this.defaultTemplate);
    }

    public String getDefaultNavigation() {
        return this.getDefaultNavigationName(this.defaultTemplate);
    }

    public String getDefaultLayoutTemplate() {
        return this.getDefaultLayoutTemplateName(this.defaultTemplate);
    }

    public String getDefaultPageName(String template) {
        return this.getDefaultModuleName(template, 0);
    }

    public String getDefaultScreenName(String template) {
        return this.getDefaultModuleName(template, 1);
    }

    public String getDefaultLayoutName(String template) {
        return this.getDefaultModuleName(template, 2);
    }

    public String getDefaultNavigationName(String template) {
        return this.getDefaultModuleName(template, 3);
    }

    public String getDefaultLayoutTemplateName(String template) {
        String layoutTemplate = this.getDefaultModuleName(template, 4);
        if (layoutTemplate != null && layoutTemplate.indexOf(46) < 0) {
            int dotIndex = template.lastIndexOf(46);
            layoutTemplate = layoutTemplate + (dotIndex >= 0 ? template.substring(dotIndex) : "." + this.defaultExtension);
        }
        return layoutTemplate;
    }

    public String getDefaultPageName(RunData data) {
        String template = data.getParameters().get("template");
        return template != null ? this.getDefaultPageName(template) : this.getDefaultPage();
    }

    public String getDefaultLayoutName(RunData data) {
        String template = data.getParameters().get("template");
        return template != null ? this.getDefaultLayoutName(template) : this.getDefaultLayout();
    }

    public String getScreenName(String template) throws Exception {
        return this.getCachedName(template, 1);
    }

    public String getLayoutName(String template) throws Exception {
        return this.getCachedName(template, 2);
    }

    public String getNavigationName(String template) throws Exception {
        return this.getCachedName(template, 3);
    }

    public String getScreenTemplateName(String template) throws Exception {
        return this.getCachedName(template, 5);
    }

    public String getLayoutTemplateName(String template) throws Exception {
        return this.getCachedName(template, 4);
    }

    public String[] translateTemplatePaths(String[] templatePaths) {
        int i = 0;
        while (i < templatePaths.length) {
            templatePaths[i] = TurbineServlet.getRealPath(templatePaths[i]);
            ++i;
        }
        return templatePaths;
    }

    public boolean templateExists(String template, String[] templatePaths) {
        int i = 0;
        while (i < templatePaths.length) {
            if (new File(templatePaths[i], template).exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void registerTemplateEngineService(TemplateEngineService service) {
        HashMap registry = this.templateEngineRegistry != null ? (HashMap)this.templateEngineRegistry.clone() : new HashMap();
        String[] exts = service.getAssociatedFileExtensions();
        int i = 0;
        while (i < exts.length) {
            registry.put(exts[i], service);
            ++i;
        }
        this.templateEngineRegistry = registry;
    }

    protected TemplateEngineService getTemplateEngineService(String template) {
        HashMap registry = this.templateEngineRegistry;
        if (registry != null && template != null) {
            int dotIndex = template.lastIndexOf(46);
            String ext = dotIndex == -1 ? this.defaultExtension : template.substring(dotIndex + 1);
            return (TemplateEngineService)registry.get(ext);
        }
        return null;
    }

    protected String getDefaultModuleName(String template, int key) {
        TemplateEngineService tes = this.getTemplateEngineService(template);
        return tes != null ? (String)tes.getTemplateEngineServiceConfiguration().get(this.defaultNameProperties[key]) : null;
    }

    protected String getCachedName(String template, int key) throws Exception {
        String found;
        if (template.indexOf(46) < 0) {
            template = template + "." + this.defaultExtension;
        }
        if (this.useCache && (found = (String)this.templateNameCache[key].get(template)) != null) {
            return found;
        }
        switch (key) {
            case 5: {
                found = this.getParsedScreenTemplateName(template);
                break;
            }
            case 4: {
                found = this.getParsedLayoutTemplateName(template);
                break;
            }
            default: {
                found = this.getParsedModuleName(template, key);
            }
        }
        if (this.useCache) {
            this.templateNameCache[key].put(template, found);
        }
        return found;
    }

    protected String getParsedModuleName(String template, int key) throws Exception {
        int j;
        StringBuffer pckage = new StringBuffer();
        int i = this.parseTemplatePath(template, pckage);
        if (pckage.charAt(0) == '/') {
            pckage.deleteCharAt(0);
            --i;
        }
        if (i >= 0) {
            j = 0;
            while (j <= i) {
                if (pckage.charAt(j) == '/') {
                    pckage.setCharAt(j, '.');
                }
                ++j;
            }
        }
        j = i + 1;
        while (j < pckage.length()) {
            if (pckage.charAt(j) == '.') {
                pckage.delete(j, pckage.length());
                break;
            }
            ++j;
        }
        j = 9999;
        while (j-- > 0) {
            String module = pckage.toString();
            try {
                switch (key) {
                    case 1: {
                        ScreenLoader.getInstance().getInstance(module);
                        return module;
                    }
                    case 2: {
                        LayoutLoader.getInstance().getInstance(module);
                        return module;
                    }
                    case 3: {
                        NavigationLoader.getInstance().getInstance(module);
                        return module;
                    }
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            pckage.setLength(i + 1);
            if (i > 0) {
                i = pckage.length() - 2;
                while (i >= 0) {
                    if (pckage.charAt(i) != '.') {
                        --i;
                        continue;
                    }
                    break;
                }
            } else if (j > 0) {
                j = 1;
            }
            pckage.append("Default");
        }
        return this.getDefaultModuleName(template, key);
    }

    protected String getParsedScreenTemplateName(String template) throws Exception {
        StringBuffer path = new StringBuffer();
        this.parseTemplatePath(template, path);
        if (path.charAt(0) != '/') {
            path.insert(0, '/');
        }
        path.insert(0, "screens");
        TemplateEngineService tes = this.getTemplateEngineService(template);
        if (tes == null || !tes.templateExists(path.toString())) {
            throw new Exception("Screen template '" + template + "' not found");
        }
        return path.substring(7);
    }

    protected String getParsedLayoutTemplateName(String template) throws Exception {
        StringBuffer path = new StringBuffer();
        int i = this.parseTemplatePath(template, path);
        if (path.charAt(0) != '/') {
            path.insert(0, '/');
            ++i;
        }
        path.insert(0, "layouts");
        i += 7;
        TemplateEngineService tes = this.getTemplateEngineService(template);
        if (tes == null) {
            throw new Exception("Layout template '" + template + "' not found");
        }
        String defaultLayout = this.getDefaultLayoutTemplateName(template);
        if (defaultLayout != null) {
            if (defaultLayout.length() == 0) {
                defaultLayout = null;
            } else if (defaultLayout.charAt(0) != '/') {
                defaultLayout = "/" + defaultLayout;
            }
        }
        int j = 9999;
        while (j-- > 0) {
            String layoutTemplate = path.toString();
            if (tes.templateExists(layoutTemplate)) {
                return layoutTemplate.substring(7);
            }
            if (defaultLayout == null) {
                throw new Exception("Layout template '" + template + "' not found");
            }
            path.setLength(i);
            if (i > 8) {
                i = path.length() - 2;
                while (i >= 8) {
                    if (path.charAt(i) != '/') {
                        --i;
                        continue;
                    }
                    break;
                }
            } else if (j > 0) {
                j = 1;
            }
            path.append(defaultLayout);
        }
        return defaultLayout;
    }

    private int parseTemplatePath(String template, StringBuffer buffer) throws Exception {
        int j = 0;
        int ind = -1;
        buffer.setLength(0);
        buffer.append(template);
        int len = buffer.length();
        while (j < len) {
            char c = buffer.charAt(j);
            if (c == ',') {
                c = '/';
                buffer.setCharAt(j, c);
            }
            if (c == '/') {
                ind = j;
                if (j < len - 1 && ((c = buffer.charAt(j + 1)) == '/' || c == ',')) {
                    buffer.deleteCharAt(j);
                    --len;
                    continue;
                }
            }
            ++j;
        }
        if (len == 0 || ind >= len - 1) {
            throw new Exception("Syntax error in template name '" + template + "'");
        }
        return ind;
    }

    private void initTemplate() {
        Configuration config = this.getConfiguration();
        this.defaultExtension = config.getString("default.extension", NO_FILE_EXT);
        this.defaultTemplate = "Default." + this.defaultExtension;
        this.useCache = TurbineResources.getBoolean("module.cache", true);
        if (this.useCache) {
            int screenSize = config.getInt("screen.cache.size", 5);
            int screenTemplateSize = config.getInt("screen.cache.size", 50);
            int layoutSize = config.getInt("layout.cache.size", 5);
            int layoutTemplateSize = config.getInt("layout.cache.size", 5);
            int navigationSize = config.getInt("navigation.cache.size", 10);
            this.templateNameCache[0] = null;
            this.templateNameCache[1] = new Hashtable((int)(1.25 * (double)screenSize) + 1);
            this.templateNameCache[5] = new Hashtable((int)(1.25 * (double)screenTemplateSize) + 1);
            this.templateNameCache[2] = new Hashtable((int)(1.25 * (double)layoutSize) + 1);
            this.templateNameCache[4] = new Hashtable((int)(1.25 * (double)layoutTemplateSize) + 1);
            this.templateNameCache[3] = new Hashtable((int)(1.25 * (double)navigationSize) + 1);
        }
    }
}

