from typing import Any

from typing import overload
import mrpt.pymrpt.mrpt
import mrpt.pymrpt.mrpt.config
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.mrpt.rtti
import mrpt.pymrpt.mrpt.serialization

class CKinematicChain(mrpt.pymrpt.mrpt.serialization.CSerializable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CKinematicChain) -> None: ...
    @overload
    def __init__(self, arg0: CKinematicChain) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def addLink(self, theta: float, d: float, a: float, alpha: float, is_prismatic: bool) -> None: ...
    def assign(self) -> CKinematicChain: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getLink(self, idx: int) -> TKinematicLink: ...
    def getLinkRef(self, idx: int) -> TKinematicLink: ...
    def getOriginPose(self) -> mrpt.pymrpt.mrpt.poses.CPose3D: ...
    @overload
    def removeLink(self, idx: int) -> None: ...
    @overload
    def removeLink(size_t) -> void: ...
    @overload
    def setOriginPose(self, new_pose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setOriginPose(constclassmrpt) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CVehicleSimulVirtualBase:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CVehicleSimulVirtualBase) -> None: ...
    def assign(self) -> CVehicleSimulVirtualBase: ...
    def getCurrentGTPose(self) -> mrpt.pymrpt.mrpt.math.TPose2D: ...
    def getCurrentGTVel(self, *args, **kwargs) -> Any: ...
    def getCurrentGTVelLocal(self, *args, **kwargs) -> Any: ...
    def getCurrentOdometricPose(self) -> mrpt.pymrpt.mrpt.math.TPose2D: ...
    def getCurrentOdometricVel(self, *args, **kwargs) -> Any: ...
    def getCurrentOdometricVelLocal(self, *args, **kwargs) -> Any: ...
    @overload
    def getTime(self) -> float: ...
    @overload
    def getTime() -> double: ...
    def getVelCmdType(self) -> CVehicleVelCmd: ...
    @overload
    def resetStatus(self) -> None: ...
    @overload
    def resetStatus() -> void: ...
    @overload
    def resetTime(self) -> None: ...
    @overload
    def resetTime() -> void: ...
    @overload
    def sendVelCmd(self, cmd_vel: CVehicleVelCmd) -> None: ...
    @overload
    def sendVelCmd(constclassmrpt) -> void: ...
    @overload
    def setCurrentGTPose(self, pose: mrpt.pymrpt.mrpt.math.TPose2D) -> None: ...
    @overload
    def setCurrentGTPose(conststructmrpt) -> void: ...
    @overload
    def setOdometryErrors(self, enabled: bool) -> None: ...
    @overload
    def setOdometryErrors(self, enabled: bool, Ax_err_bias: float) -> None: ...
    @overload
    def setOdometryErrors(self, enabled: bool, Ax_err_bias: float, Ax_err_std: float) -> None: ...
    @overload
    def setOdometryErrors(self, enabled: bool, Ax_err_bias: float, Ax_err_std: float, Ay_err_bias: float) -> None: ...
    @overload
    def setOdometryErrors(self, enabled: bool, Ax_err_bias: float, Ax_err_std: float, Ay_err_bias: float, Ay_err_std: float) -> None: ...
    @overload
    def setOdometryErrors(self, enabled: bool, Ax_err_bias: float, Ax_err_std: float, Ay_err_bias: float, Ay_err_std: float, Aphi_err_bias: float) -> None: ...
    @overload
    def setOdometryErrors(self, enabled: bool, Ax_err_bias: float, Ax_err_std: float, Ay_err_bias: float, Ay_err_std: float, Aphi_err_bias: float, Aphi_err_std: float) -> None: ...
    def simulateOneTimeStep(self, dt: float) -> None: ...

class CVehicleSimul_DiffDriven(CVehicleSimulVirtualBase):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CVehicleSimul_DiffDriven) -> None: ...
    @overload
    def __init__(self, arg0: CVehicleSimul_DiffDriven) -> None: ...
    def assign(self) -> CVehicleSimul_DiffDriven: ...
    @overload
    def getV(self) -> float: ...
    @overload
    def getV() -> double: ...
    def getVelCmdType(self) -> CVehicleVelCmd: ...
    @overload
    def getW(self) -> float: ...
    @overload
    def getW() -> double: ...
    def movementCommand(self, lin_vel: float, ang_vel: float) -> None: ...
    @overload
    def sendVelCmd(self, cmd_vel: CVehicleVelCmd) -> None: ...
    @overload
    def sendVelCmd(constclassmrpt) -> void: ...
    @overload
    def setDelayModelParams(self) -> None: ...
    @overload
    def setDelayModelParams(self, TAU_delay_sec: float) -> None: ...
    @overload
    def setDelayModelParams(self, TAU_delay_sec: float, CMD_delay_sec: float) -> None: ...
    @overload
    def setV(self, v: float) -> None: ...
    @overload
    def setV(double) -> void: ...
    @overload
    def setW(self, w: float) -> None: ...
    @overload
    def setW(double) -> void: ...

class CVehicleSimul_Holo(CVehicleSimulVirtualBase):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CVehicleSimul_Holo) -> None: ...
    @overload
    def __init__(self, arg0: CVehicleSimul_Holo) -> None: ...
    def assign(self) -> CVehicleSimul_Holo: ...
    def getVelCmdType(self) -> CVehicleVelCmd: ...
    @overload
    def sendVelCmd(self, cmd_vel: CVehicleVelCmd) -> None: ...
    @overload
    def sendVelCmd(constclassmrpt) -> void: ...
    def sendVelRampCmd(self, vel: float, dir: float, ramp_time: float, rot_speed: float) -> None: ...

class CVehicleVelCmd(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.Stringifyable):
    class TVelCmdParams:
        robotMax_V_mps: float
        robotMax_W_radps: float
        robotMinCurvRadius: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CVehicleVelCmd.TVelCmdParams) -> None: ...
        def assign(self) -> CVehicleVelCmd.TVelCmdParams: ...
        @overload
        def loadConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CVehicleVelCmd) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self, other: CVehicleVelCmd) -> CVehicleVelCmd: ...
    @overload
    def cmdVel_limits(self, prev_vel_cmd: CVehicleVelCmd, beta: float, params) -> float: ...
    @overload
    def cmdVel_limits(constclassmrpt, constdouble, conststructmrpt) -> double: ...
    @overload
    def cmdVel_scale(self, vel_scale: float) -> None: ...
    @overload
    def cmdVel_scale(double) -> void: ...
    def getVelCmdDescription(self, index: int) -> str: ...
    @overload
    def getVelCmdElement(self, index: int) -> float: ...
    @overload
    def getVelCmdElement(constint) -> double: ...
    @overload
    def getVelCmdLength(self) -> int: ...
    @overload
    def getVelCmdLength() -> size_t: ...
    @overload
    def isStopCmd(self) -> bool: ...
    @overload
    def isStopCmd() -> bool: ...
    @overload
    def setToStop(self) -> None: ...
    @overload
    def setToStop() -> void: ...
    @overload
    def setVelCmdElement(self, index: int, val: float) -> None: ...
    @overload
    def setVelCmdElement(constint, constdouble) -> void: ...

class CVehicleVelCmd_DiffDriven(CVehicleVelCmd):
    ang_vel: float
    lin_vel: float
    @overload
    def __init__(self, arg0: CVehicleVelCmd_DiffDriven) -> None: ...
    @overload
    def __init__(self, arg0: CVehicleVelCmd_DiffDriven) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CVehicleVelCmd_DiffDriven: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def cmdVel_limits(self, prev_vel_cmd: CVehicleVelCmd, beta: float, params: CVehicleVelCmd.TVelCmdParams) -> float: ...
    @overload
    def cmdVel_limits(constclassmrpt, constdouble, conststructmrpt) -> double: ...
    @overload
    def cmdVel_scale(self, vel_scale: float) -> None: ...
    @overload
    def cmdVel_scale(double) -> void: ...
    def getVelCmdDescription(self, index: int) -> str: ...
    @overload
    def getVelCmdElement(self, index: int) -> float: ...
    @overload
    def getVelCmdElement(constint) -> double: ...
    @overload
    def getVelCmdLength(self) -> int: ...
    @overload
    def getVelCmdLength() -> size_t: ...
    @overload
    def isStopCmd(self) -> bool: ...
    @overload
    def isStopCmd() -> bool: ...
    @overload
    def setToStop(self) -> None: ...
    @overload
    def setToStop() -> void: ...
    @overload
    def setVelCmdElement(self, index: int, val: float) -> None: ...
    @overload
    def setVelCmdElement(constint, constdouble) -> void: ...

class CVehicleVelCmd_Holo(CVehicleVelCmd):
    dir_local: float
    ramp_time: float
    rot_speed: float
    vel: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, vel: float, dir_local: float, ramp_time: float, rot_speed: float) -> None: ...
    @overload
    def __init__(self, arg0: CVehicleVelCmd_Holo) -> None: ...
    @overload
    def __init__(self, arg0: CVehicleVelCmd_Holo) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CVehicleVelCmd_Holo: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def cmdVel_limits(self, prev_vel_cmd: CVehicleVelCmd, beta: float, params: CVehicleVelCmd.TVelCmdParams) -> float: ...
    @overload
    def cmdVel_limits(constclassmrpt, constdouble, conststructmrpt) -> double: ...
    @overload
    def cmdVel_scale(self, vel_scale: float) -> None: ...
    @overload
    def cmdVel_scale(double) -> void: ...
    def getVelCmdDescription(self, index: int) -> str: ...
    @overload
    def getVelCmdElement(self, index: int) -> float: ...
    @overload
    def getVelCmdElement(constint) -> double: ...
    @overload
    def getVelCmdLength(self) -> int: ...
    @overload
    def getVelCmdLength() -> size_t: ...
    @overload
    def isStopCmd(self) -> bool: ...
    @overload
    def isStopCmd() -> bool: ...
    @overload
    def setToStop(self) -> None: ...
    @overload
    def setToStop() -> void: ...
    @overload
    def setVelCmdElement(self, index: int, val: float) -> None: ...
    @overload
    def setVelCmdElement(constint, constdouble) -> void: ...

class TKinematicLink:
    a: float
    alpha: float
    d: float
    is_prismatic: bool
    theta: float
    @overload
    def __init__(self, _theta: float, _d: float, _a: float, _alpha: float, _is_prismatic: bool) -> None: ...
    @overload
    def __init__(self) -> None: ...
