# This file should be included if the command line reads like this:
# x86_64-w64-mingw32.shared-cmake -DMXE=1 ...

MESSAGE("MXE (M cross environment) https://mxe.cc/")
message("Please run the configuration like this:")
message("x86_64-w64-mingw32.shared-cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Release ../../development")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/include)

set(MXE_ROOT_DIR "${HOME_DEVEL_DIR}/mxe")
set(MXE_SHIPPED_DLLS_DIR "${MXE_ROOT_DIR}/dll-set-for-packages")

# We are building the lib, so need to export the symbols.
# Also we want the code to know that we are building for MXE
# because there are occasional #ifdef for code that must be
# adapted (older Qt libs in MXE)
add_definitions(-DEXPORT_LIB_SYMBOLS -DMXE)

find_package(
    Qt6
    COMPONENTS Core
               Svg
               Xml
               Network
               PrintSupport
               Qml
               Sql
               Concurrent
               Core5Compat
    REQUIRED
)

set(IsoSpec++_FOUND 1)
set(IsoSpec++_INCLUDE_DIRS "${HOME_DEVEL_DIR}/isospec/development")
set(IsoSpec++_LIBRARIES "${MXE_SHIPPED_DLLS_DIR}/libIsoSpec++.dll")
if(NOT TARGET IsoSpec++::IsoSpec++)
  add_library(IsoSpec++::IsoSpec++ UNKNOWN IMPORTED)
  set_target_properties(IsoSpec++::IsoSpec++ PROPERTIES
    IMPORTED_LOCATION             "${IsoSpec++_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${IsoSpec++_INCLUDE_DIRS}")
endif()


set(PappsoMSpp_FOUND 1)
set(PappsoMSpp_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pappsomspp/development/src")
set(PappsoMSpp_LIBRARIES
  "${MXE_SHIPPED_DLLS_DIR}/libpappsomspp-core.dll")
if(NOT TARGET PappsoMSpp::Core)

  add_library(PappsoMSpp::Core UNKNOWN IMPORTED GLOBAL)
  set_target_properties(PappsoMSpp::Core PROPERTIES
    IMPORTED_LOCATION ${PappsoMSpp_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${PappsoMSpp_INCLUDE_DIRS})

endif()


set(PappsoMSppGui_FOUND 1)
set(PappsoMSppGui_LIBRARIES
  "${MXE_SHIPPED_DLLS_DIR}/libpappsomspp-gui.dll")
if(NOT TARGET PappsoMSpp::Gui)

  add_library(PappsoMSpp::Gui UNKNOWN IMPORTED GLOBAL)
  set_target_properties(PappsoMSpp::Gui PROPERTIES
    IMPORTED_LOCATION ${PappsoMSppGui_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${PappsoMSpp_INCLUDE_DIRS})

endif()

include_directories(${include_directories} ${PappsoMSpp_INCLUDE_DIRS} ${PappsoMSpp_INCLUDE_DIRS})


find_package(ZLIB REQUIRED)

find_package(SQLite3 REQUIRED)

find_package(
    Boost
    COMPONENTS chrono
               container
               filesystem
               iostreams
               thread
    REQUIRED
)

find_package(Catch2)
message("Catch2 major version found: " ${Catch2_VERSION_MAJOR})
add_compile_definitions(CATCH2_MAJOR_VERSION_${Catch2_VERSION_MAJOR})

set(QCustomPlotQt6_FOUND 1)
set(QCustomPlotQt6_INCLUDE_DIR "${HOME_DEVEL_DIR}/qcustomplot/development")
set(QCustomPlotQt6_LIBRARIES "${HOME_DEVEL_DIR}/qcustomplot/build-area/mxe/libQCustomPlotQt6.dll")
if(NOT TARGET QCustomPlotQt6::QCustomPlotQt6)
    add_library(QCustomPlotQt6::QCustomPlotQt6 UNKNOWN IMPORTED)
    set_target_properties(
        QCustomPlotQt6::QCustomPlotQt6
        PROPERTIES IMPORTED_LOCATION "${QCustomPlotQt6_LIBRARIES}"
                   INTERFACE_INCLUDE_DIRECTORIES "${QCustomPlotQt6_INCLUDE_DIR}"
                   INTERFACE_COMPILE_DEFINITIONS QCUSTOMPLOT_USE_LIBRARY
    )
endif()

# Unfortunately no CMake configuration file is available.
# find_package(QUAZIP REQUIRED)

set(QUAZIP_FOUND 1)
set(QUAZIP_INCLUDE_DIR "${HOME_DEVEL_DIR}/quazip/development/quazip")
set(QUAZIP_LIBRARIES "${HOME_DEVEL_DIR}/quazip/build-area/mxe/quazip/libquazip1-qt6.dll")
set(QUAZIP_ZLIB_INCLUDE_DIR ${ZLIB_INCLUDE_DIRS})
set(QUAZIP_INCLUDE_DIRS ${QUAZIP_INCLUDE_DIR} ${QUAZIP_ZLIB_INCLUDE_DIR})

message(STATUS "QUAZIP_INCLUDE_DIR :${QUAZIP_INCLUDE_DIR}")

if(NOT TARGET QuaZip::QuaZip)
    add_library(QuaZip::QuaZip UNKNOWN IMPORTED)
    set_target_properties(
        QuaZip::QuaZip PROPERTIES IMPORTED_LOCATION ${QUAZIP_LIBRARIES} INTERFACE_INCLUDE_DIRECTORIES
                                                                        ${QUAZIP_INCLUDE_DIR}
    )
endif()

set(OdsStream_FOUND 1)
set(OdsStream_INCLUDE_DIR "${HOME_DEVEL_DIR}/odsstream/development/src")
set(OdsStream_LIBRARIES "${HOME_DEVEL_DIR}/odsstream/build-area/mxe/src/libodsstream.dll")
if(NOT TARGET OdsStream::Core)
    add_library(OdsStream::Core UNKNOWN IMPORTED)
    set_target_properties(
        OdsStream::Core PROPERTIES IMPORTED_LOCATION "${OdsStream_LIBRARIES}" INTERFACE_INCLUDE_DIRECTORIES
                                                                              "${OdsStream_INCLUDE_DIR}"
    )
endif()

find_package(Zstd REQUIRED)

set(PwizLite_FOUND 1)
set(PwizLite_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pwizlite/development/src")
set(PwizLite_LIBRARIES "${HOME_DEVEL_DIR}/pwizlite/build-area/mxe/src/libpwizlite.dll")
if(NOT TARGET PwizLite::PwizLite)
    add_library(PwizLite::PwizLite UNKNOWN IMPORTED)
    set_target_properties(
        PwizLite::PwizLite PROPERTIES IMPORTED_LOCATION "${PwizLite_LIBRARIES}" INTERFACE_INCLUDE_DIRECTORIES
                                                                                "${PwizLite_INCLUDE_DIRS}"
    )
endif()

set(liblzf_FOUND 1)
set(liblzf_INCLUDE_DIRS "${HOME_DEVEL_DIR}/lzf/development")

set(liblzf_LIBRARIES "${HOME_DEVEL_DIR}/lzf/build-area/mxe/liblzf.dll")
if(NOT TARGET liblzf::liblzf)
    add_library(liblzf::liblzf UNKNOWN IMPORTED)
    set_target_properties(
        liblzf::liblzf
        PROPERTIES IMPORTED_LOCATION "${liblzf_LIBRARIES}"
                   INTERFACE_INCLUDE_DIRECTORIES "${liblzf_INCLUDE_DIRS}"
                   INTERFACE_COMPILE_DEFINITIONS LIBLZF_USE_LIBRARY
    )
endif()


set(QScintilla_FOUND 1)
set(QScintilla_INCLUDE_DIRS "${HOME_DEVEL_DIR}/qscintilla2/development/src")
set(QScintilla_LIBRARIES "${HOME_DEVEL_DIR}/qscintilla2/build-area/mxe/src/libqscintilla2_qt6.dll")
if(NOT TARGET QScintilla::QScintilla)
  add_library(QScintilla::QScintilla UNKNOWN IMPORTED)
  set_target_properties(QScintilla::QScintilla PROPERTIES
    IMPORTED_LOCATION             "${QScintilla_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${QScintilla_INCLUDE_DIRS}")
endif()


#OPENMP
message(STATUS "${BoldYellow}OpenMP support is compulsory.${ColourReset}")
#message(STATUS "CMAKE_MODULE_PATH: ${CMAKE_MODULE_PATH}")
#set(OpenMP_DIR ${CMAKE_MODULE_PATH})

find_package(OpenMP REQUIRED)

set(CORE_SOURCE_LIB ${CMAKE_BINARY_DIR}/source/XpertMassCore/libXpertMassCore.dll)
set(GUI_SOURCE_LIB ${CMAKE_BINARY_DIR}/source/XpertMassGui/libXpertMassGui.dll)

## We can build the package setup executable with this specific command.
add_custom_target(dllinstall
  COMMAND ${CMAKE_COMMAND} -E copy ${CORE_SOURCE_LIB} ${GUI_SOURCE_LIB} ${MXE_SHIPPED_DLLS_DIR}
  COMMENT "Build and copy the dll files to their MXE destination."
  DEPENDS ${CORE_SOURCE_LIB} ${GUI_SOURCE_LIB}
  VERBATIM)


# On Win10 all the code is relocatable.
remove_definitions(-fPIC)


