/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


#ifndef LLGT_UTILS_H
#define LLGT_UTILS_H

/* Configure options */
#include "llgt_config.h"

/* For LOG_* */
#include <syslog.h>

/* For PATH_MAX or MAXPATHLEN */
#include <limits.h>

/* For gss_ctx_id_t and gss_cred_id_t */
#include <gssapi.h>

#define MAX_ERRORBUF_LEN ((size_t)512U)

/* Not all platforms have PATH_MAX, make a suitable default */
#if defined(PATH_MAX)
 #define AP_MAXPATH ((size_t)PATH_MAX)
#elif defined(MAXPATHLEN)
 #define AP_MAXPATH ((size_t)MAXPATHLEN)
#else
 #define AP_MAXPATH ((size_t)4096U)
#endif

/* Define platform dependent dynamic library suffix */
#ifndef LIBSUFF
 #ifdef __APPLE__
  #define LIBSUFF       ".dylib"
 #else
  #define LIBSUFF       ".so"
 #endif
#endif

/* Prototypes */
globus_result_t llgt_get_client_name(gss_ctx_id_t context, char **client_name);
gss_cred_id_t llgt_get_user_cred_handle(gss_ctx_id_t context_handle);

/* Convert a pemstring into a (new) gss_cred_id_t and the DN of the EEC */
globus_result_t llgt_pem_to_gsscred(char *pem_buf,
				    gss_cred_id_t *gss_cred,
				    char **clientname);

void llgt_cleanup_gss_cred_id_t(gss_cred_id_t user_cred_handle);

void llgt_open_log(void);
void llgt_close_log(void);

#ifdef __GNUC__
void llgt_logmsg (int priority, const char* format, ...)
    __attribute__((format(printf,2,3)));
#else
void llgt_logmsg (int priority, const char* format, ...);
#endif

void llgt_enable_debugging_mode(void);
int llgt_is_debugmode_enabled(void);

int llgt_create_jobid(void);

#endif /* UTILS_H */
