#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("exits review mode")

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "review", "leaveReviewOnCursorChange"
        ):
            return
        if self.env["runtime"]["CursorManager"].is_review_mode():
            self.env["runtime"]["CursorManager"].clear_review_cursor()

    def set_callback(self, callback):
        pass
