/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Copyright (c) 2025, Richard Acayan. All rights reserved.
 */

#ifndef QVD_MESSAGE_H
#define QVD_MESSAGE_H

#include <gio/gio.h>
#include <glib.h>
#include <libqrtr.h>

G_BEGIN_DECLS

#define QVD_TYPE_MESSAGE qvd_message_get_type()
G_DECLARE_FINAL_TYPE(QVDMessage, qvd_message, QVD, MESSAGE, GObject)

QVDMessage *qvd_message_new(GSocket *sock,
			    const struct qrtr_packet *req,
			    guint32 node, guint32 port);

guint qvd_message_get_msg_id(QVDMessage *ctx);
void qvd_message_decode(QVDMessage *ctx,
			void *c_struct,
			struct qmi_elem_info *ei,
			GError **err);
void qvd_message_respond(QVDMessage *ctx,
			 const void *c_struct,
			 struct qmi_elem_info *ei,
			 GError **err);

G_END_DECLS

#endif /* QVD_MESSAGE_H */
